/******************** (C) COPYRIGHT 2007 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Date First Issued  : 05/30/2007 : Version 1.0
* Description        : A sample demonstration program  supplied to demonstrate
*                      and test the EEPROM Emulation driver using  3 variables
*                      A, B and C already defined.
********************************************************************************
* History:
*05/30/2007 : Version 1.0
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/
/* Includes ------------------------------------------------------------------*/
#include "91x_lib.h"
#include "EEPROM.h"
#include "main.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void main(void)
{
  u32 Tab[max_varia]   = {A, B, C};

#ifdef DEBUG
  debug();
#endif


  /* Enable the clock for FMI */
  SCU_AHBPeriphClockConfig(__FMI, ENABLE);
  SCU_AHBPeriphReset(__FMI, DISABLE);


  /* -------------------------------------------------------------------------*/
  /*                Configure bank 0 as 512KB and bank 1 as 32KB              */
  /*        Configure bank 0 at address 0x0 and bank 1 at address 0x80000     */
  /* -------------------------------------------------------------------------*/

  FMI_BankRemapConfig(0x4, 0x2, 0x0, 0x80000);

  /* ------------------------------------------------------------------------ */
  /*       Disable the Write protection for sector0/sector1 of bank 1         */
  /* ------------------------------------------------------------------------ */

  FMI_WriteProtectionCmd(FMI_B1S0, DISABLE);
  FMI_WriteProtectionCmd(FMI_B1S1, DISABLE);

 
  EepromFormat();
  

  /**************************Application Example*******************************/

  /**Variable A update  until there is insufficient memory space to allocate***/
 
  for (i = 0; i < 639; i++)

  {
    WriteVariable(0, Tab, 0x1211);

  }
  
  /************************ Variable B update**********************************/
  
  for (i = 0; i < 7; i++)

  {
    WriteVariable(1, Tab, 0x2333);

  }
 
 /************************ Variable C update***********************************/
 
  for (i = 0; i < 3447; i++)

  {
    WriteVariable(2, Tab, 0x4445);

  }
 
}
/******************* (C) COPYRIGHT 2007 STMicroelectronics *****END OF FILE****/
